#!/bin/bash

# using the trap to do manual cleanup after the container should be stopped
trap cleanup HUP INT QUIT TERM

cleanup()
{
    kill -TERM "$child" 2>/dev/null
    kill -TERM "$other_child" 2>/dev/null

    # stop services and clean up here
    service nginx stop
    service uwsgi stop
    service postgresql stop

    echo "exited $0"
    exit 0
}

# starting services
service uwsgi start
service nginx start
service postgresql start

#Execute download processor and Wait here
python /sentinelApp/execDownloader/downloaderMain.py &
# { { python /sentinelApp/execDownloader/downloaderMain.py; } & } > /var/log/SentMain.log 2>&1
child=$!
{ { python /sentinelApp/execDownloader/downloaderSecondary.py; } & } > /var/log/SentQueue.log 2>&1
other_child=$!
wait "$child"
