# README #
**Copyright 2020 Logic and Optimization Group, Universitat de Lleida. All Rights Reserved.**

Sentinel satellite downloader web-service through a REST API. Python based.
Dockerfile provided for easy deployment.

Create an account at create an account at https://scihub.copernicus.eu/dhus/#/self-registration and modify the Dockerfile.

To deploy and run (from outside the folder):

* Build the image
    ```
    $ docker build -t log/sentinelws:latest ./sentineldownloaderws/
    ```
* To Run *Without mounted volumes*
    ```
    $ docker run -d -p 5000:80 --name senws_cont log/sentinelws
    ```
* To Run *With mounted volumes*
    ```
    $ docker run -d -p 5000:80 -v /path/to/fold1:/opt/sat_down_dir/ -v /path/to/fold2:/opt/sat_proc_dir/ -v /path/to/fold3:/opt/sentinelDB --name senws_cont log/sentinelws
    ```

This Dockerfile provides 3 volumes that can be mapped to external folders:

* $SAT_DOWN_DIR: folder where the satellite data will be downloaded
* $SAT_PROC_DIR: folder where the processed data will be stored
* $QUEUE_DB_DIR: folder where the Database data will be stored

---

## Architecture

There are two main components connected by a postgreSQL database and the filesystem.

```
WebService -> DB -> DownloaderExecutor
    |                        |
    '----> Filesystem < -----'
```

On one side, the WebService backend will responds to user-triggered Satellite imaging requests through the REST API. The Webservice backend will enqueue the download requests into a postgreSQL database, as well as allow to check the status of the ongoing request or retrieve the already processed images.

On the other side, the Downloader executor will process the enqueued requests from the database. In doing so, will update the state on the DB accordingly and download the requested images and process them (crop to FOI, warp to EPSG, compute NDVI).


---

## REST API
The API is composed of 3 principal methods:

- enqueue_request,
- request_status, and
- get_result

These methods are given in more detail below. As these methods will not be available in a front-facing application, but are part of a backend, login security has not been considered.

### **/enqueue_request**
HTTP POST

**Parameters:**

- from_date: initial date (datetime) of the requested time range
- to_date: final date (datetime) of the requested time range
- foi: Geometry of the requested parcel in GEOJSON
- epsg: “Default” (equivalent to “EPSG:4326”) or a specific EPSG for the final images
- cloud_cover: maximum allowed cloud cover percentage
- proc_mask_probability: minimum percent of probability of a pixel to be declared masked
- proc_min_pix_cover: minimum percent of pixels of the parcel not masked to accept the processed product
- callback: “None” or URL

**Returns:**
An ID of the enqueued request

**Description:**
The download of Sentinel images from the Copernicus servers takes some time. This method enqueues the request for the images (original bands and processed like NDVI) of a parcel. The method will return an ID of the enqueued request, which has to be used to check its status and get the resulting images in the next two methods. To filter the search from the Copernicus servers, a range of dates is required, as well as the region of interest, here defined as a GeoJSON with the geometry of the parcel. The parcel geometry will be also used to crop the resulting images. An EPSG could be specified such that the processing of the images are warped to the required coordinate system (Copernicus and thus the Sentinel images are based on WGS 84 or EPSG:4326). Additionally, a callback URL can be provided such that, when the request has been completed, that URL can be pinged back (HTTP GET) to alert that the request has been fulfilled. The image is first looked up in the disk, if it does exist no download is required; alternatively, this method will also raise a download action from the Copernicus servers.


### **/enqueue_download**
HTTP POST

**Parameters:**

- from_date: initial date (datetime) of the requested time range
- to_date: final date (datetime) of the requested time range
- foi: Geometry of the requested parcel in GEOJSON
- epsg: “Default” (equivalent to “EPSG:4326”) or a specific EPSG for the final images
- cloud_cover: maximum allowed cloud cover percentage
- callback: “None” or URL

**Returns:**
HTTP 200 on successful download enqueue

**Description:**
The download of Sentinel images from the Copernicus servers takes some time. This method enqueues the request for the images (original bands and processed like NDVI) of a particular Region of Interest (ROI). To filter the search from the Copernicus servers, a range of dates is required, as well as the region of interest, here defined as a GeoJSON with the geometry of the ROI. An EPSG could be specified such that the geometry is converted to the required coordinate system (Copernicus and thus the Sentinel images are based on WGS 84 or EPSG:4326). Additionally, a callback URL can be provided such that, when the request has been completed, that URL can be pinged back (HTTP GET) to alert that the request has been fulfilled.
This method is intended only for image download, not cropping of the ROI, thus an external periodic petition to this method will enable the download and cache function for the enqueue_request method, which will see its behaviour speeded up.

### **/request_status?id={id}**
HTTP GET

**Parameters:**

- id: ID of an enqueued request

**Returns:**
One of [ENQUEUED, IN_PROCESS, FINISHED, ERROR]

**Description:**
This method allows to check the status of an enqueued request:

- ENQUEUED means that the request is still in the queue
- IN_PROCESS means that the request is being processed
- FINISHED means that the request has been completed and its results can be gathered.
- ERROR means that the request has failed, the log will contain the reason or stacktrace.

### **/get_result?id={id}&format={list|zip}**
HTTP GET

**Parameters:**

- id: ID of an enqueued request
- format: “list” or “zip”

**Returns:**
A list of URLs or a zip file (through redirection) with the processed images associated to the enqueued request identified by ID.
If the status of ID is not FINISHED, the response will be an HTTP 404.

**Description:**
Once a request has been completed, the resulting images can be gathered. The images will be cropped to the parcel geometry and georeferenced using the GeoTiff format. This method will return the list of URIs with the images (bands and processed like NDVI) for the parcel requested or, alternatively, a zip file with the images within.
*ATTENTION!!*: When requesting with zip, allow a large timeout, so as to let the server create the zip with all the files. This creation time will only be needed the first time requesting that file; further requests will fetch the cached zip file.

### **/delete_request**
HTTP DELETE

**Parameters:**

- id: ID of an enqueued request

**Returns:**
HTTP 200 on successful operation

**Description:**
As a convenience, this method allows to delete an enqueued request.
