CREATE TYPE request_state AS ENUM ('ENQUEUED', 'IN_PROCESS', 'IN_PROCESS_HALT', 'FINISHED', 'ERROR', 'DOWN_TODO', 'DOWN_INPROC', 'DOWN_INPROC_HALT');

CREATE TABLE Queue (
    RequestID       uuid PRIMARY KEY,
    IniDate	        timestamp with time zone NOT NULL,
    EndDate	        timestamp with time zone NOT NULL,
    Foi	            json NOT NULL,
    EPSG            varchar(50) DEFAULT 'EPSG:4326',
    Cloud_Cover     smallint DEFAULT 50,
    Proc_MaskProb   smallint DEFAULT 70,
    Proc_MinPixCov  smallint DEFAULT 10,
    Req_Down        smallint DEFAULT 0,
    Callback        text NULL,
    ReqState        request_state DEFAULT 'ENQUEUED',
    TS_enqueued     timestamp DEFAULT CURRENT_TIMESTAMP,
    TS_finished     timestamp
);
