# Copyright 2020 Logic and Optimization Group, Universitat de Lleida. All Rights Reserved.
import sys
import signal
import downloadSentinel

S2_DP = None

def sig_TERM(signum, frame):
    # kill all downloads or whatever
    if S2_DP:
        S2_DP.cleanup()
    sys.exit()

def main(args, env_vars):
    full_args = {}
    full_args.update(args)
    full_args.update(env_vars)

    global S2_DP
    S2_DP = downloadSentinel.SentinelDownQueue(**full_args)
    S2_DP.doLoopProcessing()

if __name__ == '__main__':
    signal.signal(signal.SIGTERM, sig_TERM)

    enviro_vars = {}
    with open('/opt/serv_env_vars', 'r') as serv_env_vars:
        for line in serv_env_vars:
            new_var = line.strip().split('=')
            enviro_vars[new_var[0]] = new_var[1].strip("'")

    main({}, enviro_vars)
