# Copyright 2020 Logic and Optimization Group, Universitat de Lleida. All Rights Reserved.
import psycopg2 as psql
from flask import g, current_app

def get_db():
    PG_DB = current_app.config['DB_NAME'] #'sentinelQueue'
    PG_USER = current_app.config['DB_USER'] #'sentinelDL'
    db = getattr(g, '_database', None)
    if db is None:
        db = g._database = psql.connect(f"dbname={PG_DB} user={PG_USER}")
    return db

def close_db_connection(exception):
    db = getattr(g, '_database', None)
    if db is not None:
        db.close()