# Copyright 2020 Logic and Optimization Group, Universitat de Lleida. All Rights Reserved.
import connexion
from wsDatabase import close_db_connection

app = connexion.App(__name__, specification_dir='./')
app.add_api('swagger.yml', strict_validation=True, validate_responses=True)
app.app.teardown_appcontext(close_db_connection)

new_env_vars = {}
with open('/opt/serv_env_vars', 'r') as serv_env_vars:
    for line in serv_env_vars:
        new_var = line.strip().split('=')
        new_env_vars[new_var[0]] = new_var[1].strip("'")
app.app.config.from_mapping(new_env_vars)

# If we're running in stand alone mode, run the application
if __name__ == '__main__':
    app.run(host='0.0.0.0', port=5001, debug=True)
