# External Cron configuration
**Copyright 2020 Logic and Optimization Group, Universitat de Lleida. All Rights Reserved.**
*Attention: This is a markdown file. Lines starting with > are quotes from a command line (starting with $) or an editor like the crontab.*

In order to schedule automatic periodic download and removal of Sentinel images, **CRON** can be used from a Linux system.

The fact that the cron is external to the docker image allows more freedom to change or implement the cache control policies that you want.

> $ crontab -e

From the command line, this will open an editor for the cron tasks. We have two main tasks to schedule: download and deletion.

## Download
For the download we will want to schedule a task for each representative parcel. We will do so with a bash script.

Let's assume that we are going to use an `enqueue_down.sh` script, located in `/opt/bin` and with executable permissions. In the cron editor we can add the following line:

> #IN CRONTAB
>
> 1 0 * * * /opt/bin/enqueue_down.sh

This will force the `enqueue_down.sh` script to run every day at 00:01.

Let's imagine that we have a reference parcel in the file `ref_parcel.geojson` located in `/opt/geo`.
If docker is running on `10.0.0.15:5000`, the `enqueue_down.sh` script can be as simple as the following example:

    #!/bin/bash

    FROM_DATE=$(date --date="-3 days" --iso-8601=seconds -u)
    TO_DATE=$(date --iso-8601=seconds -u)
    
    curl 'http://10.0.0.15:5000/enqueue_download' -X POST -F from_date="${FROM_DATE}" -F to_date="${TO_DATE}" -F epsg="EPSG:25831" -F cloud_cover="50" -F callback="None" -F foi=@/opt/geo/ref_parcel.geojson

This script will make a download request to the docker image for the `ref_parcel` roi for the last 3 days.

## Deletion
For the deletion of Sentinel images, we can also program a specific order or a script that is responsible for deleting the different folders of satellite images.

Ideally, the `sat_down_dir` volume of the docker image will be mounted on a network drive. That is, suppose we have done the docker build from where the Dockerfile lives in the command line:

> $ docker build -t log/sentinelws:latest .

And when launching the docker image, it will be working against a directory on the network (as an example, mounted locally in `/opt/net/sat_down_dir`):

> $ docker run -t -p 5000:80 -v /opt/net/sat_down_dir:/opt/sat_down_dir --name wssentinel log/sentinelws

Then we can program the cron with the following line that we can add in the cron editor, assuming that we are going to use the `clean_cache.sh` script, which we have previously placed in `/opt/bin` and to which we have given execution permissions:

> #IN CRONTAB
>
> 30 0 * * * /opt/bin/clean_cache.sh

This will force the `clean_cache.sh` script to run every day at 00:30.

This script can contain as elaborate a cache recycling policy as you like. As an example, the following code will delete folders that are older than 60 days from the net mounted directory:

    #!/bin/bash

    MOUNT_DIR =/opt/net/sat_down_dir/
    ELAPSED_DAYS = 60
    find ${MOUNT_DIR} -maxdepth 0 -type d -mtime +${ELAPSED_DAYS} -print | xargs rm -r
